# Additive manufacturing technology and business model change – a review of literature

Savolainen Jyrki, Collan Mikael

This is a version of a publicationAuthor's accepted manuscript (AAM)   
published by Elsevier   
in Additive Manufacturing

DOI: 10.1016/j.addma.2020.101070

# Copyright of the original publication: $\circledcirc$ 2020 Elsevier

# Please cite the publication as follows:

Savolainen, J., Collan M. (2020). Additive manufacturing technology and business model change – a review of literature. Additive Manufacturing. DOI: 10.1016/j.addma.2020.101070

This is a parallel published version of an original publication. This version can differ from the original published article.

# Additive manufacturing technology and business model change – a review of literature

Jyrki Savolainen, Mikael Collan

{jyrki.savolainen; mikael.collan}@lut.fi LUT University, School of Business and Management Yliopistonkatu 34, 53850, Lappeenranta, Finland

# ABSTRACT

This paper is a literature review on business models used in the additive manufacturing industry. We focus the investigation by categorizing the effects additive manufacturing into four classes by looking at incremental and disruptive applications in closed and in open market models. The economic feasibility of these applications is critically discussed on the background of the existing literature. Additive manufacturing business models is an emerging area of research, where tangible, case-based evidence is still rare, and the views on the business potential of additive manufacturing technologies are strongly divided.

Keywords: Additive manufacturing, 3D-printing, business models, literature review

# 1. Introduction

The purpose of this paper is to serve as a review of the scientific literature regarding the effect that additive manufacturing (AM) has had and will have on manufacturing business models (BM), and on business valuechains. By synthesizing existing knowledge, we aim to provide analytic insights on how AM-technologies are likely to change the current ways of manufacturing business value-creation. We also aim to anticipate the effects of likely near-future developments caused by the potential technological changes brought about by advances in AM-technologies.

We discuss separately the two identified co-existing streams of academic literature on how AMtechnologies will shape the business of manufacturing:

1) The incremental change stream, where current industry players can enhance their earnings and position on the markets by utilizing AM-technologies.   
2) The disruptive change stream, where AM is expected to have a radical effect on the current distribution of economic value in the manufacturing industry.

A business model is generally defined as the logic of creating and capturing value through a series of interdependent activities (see, e.g., [1]–[3]). Recently this topical area has been addressed two reviews by Öberg and others [4], which is focused on and limited to a company-level analysis and by Verboeket & Krikke [5] published at the time of this article. In this review, we look at “open” network- or ecosystembased and “closed” single company-based business models around AM-technologies [1], [6], [7]. Together, these distinctions give us four alternative future projections. We are interested especially in the potential of AM-induced changes in global value chains (GVCs) resulting from the foreseeable commoditization of manufacturing.

# Current state and applications

Additive manufacturing is commonly known as 3D-printing (3DP) and is the process of manufacturing parts or products layer-by-layer, directly from digital product data. 3DP makes possible the construction of complex geometries, e.g., honeycombs and lattices that are impossible to create by using conventional manufacturing (CM) methods. After a re-design, existing products can be built by AM-technologies in a way that reduces the use of raw materials, while possibly enhancing product properties in terms of weight and functionality [8]. Expensive and exotic materials, for example, human tissue may be printed with minimal waste [9]–[12], although many of the applications are still in an experimental stage [13]. For extensive discussion on the benefits of AM, see e.g., [1], [10], [14]–[21]).

Additive manufacturing does not suffer from the cost penalties - namely machining, molding, casting, and/or specially made tooling - incurred by CM methods [9], [11], [15], [16], [22]–[24]. Today, as a result of decades of past research and development, AM is a hypernym covering several technologies with specific characteristics in terms of material selection, printing accuracy, speed, price of equipment, and finishing quality among others. For technical reviews, we advise the interested reader to see [1], [16], [18], [25]– [29].

The question of AM-technology diffusion boils down to the total process feasibility in terms of both the technology and the economics involved [30], [31]. First cost-related bottleneck is the deposition rate of material, which can be as low as 1/10 000 compared to conventional manufacturing [32] and second, the material unit cost. For example, it has been reported that AM metal powder can cost 1-3 times more [30] and AM plastic filament 50-100 times [31] more, than a comparable product used with conventional methods – even if the cost of plastic can be decreased by using recycled materials [33]. Importantly [30], in AM, the cost of raw material has a direct relationship with the production volume, which is not the case with CM. As Laplume and others [17] conclude, there are several industries which are not likely to be affected by AM, e.g., the production of raw materials. Table 1 presents a summary on decision-making issues relevant to shifting production to AM (see also [34]) – the situation reflected is that of 2011-2018.

Table 1. Feasibility issues between additive and conventional manufacturing processes, summarized from [1], [10], [15], [17], [18], [22], [30], [31], [34]–[39])

<html><body><table><tr><td>Issue</td><td>Additive</td><td>Conventional</td></tr><tr><td>Market segment</td><td>High margin,niche segmentswith high customization and relatively low economic potential of product</td><td>Lowmarginmass segmentswith low customizationand high economies of scale</td></tr><tr><td>Demand and supply chain</td><td>Uncertain/unitarydemand,whichisbest matchedwith engineering to order deliveries;highorderfulfillment requirements;and/or high relative transportation costs versusproduct value</td><td>Stable/uncertaindemand,when products can bemade stock and shipped with negligible costsrelative to product value</td></tr><tr><td>Intellectual Property Rights (IPR) status</td><td>Expired/un-patented/un-branded products with low standardization requirements</td><td>Highly branded products (=mass market) with established standards and patents</td></tr><tr><td>Production process</td><td>Lowlevel ofautomationwitha high number of distinct production phases that AMcanintegrate</td><td>High level of automationand alimited number of processphases</td></tr><tr><td>Product</td><td>Small productswith highly complex structures;flexible product quality characteristicsrequirementsin terms offinishing,strength, etc.</td><td>Products ofany size with maximum quality required</td></tr><tr><td>Rawmaterial type</td><td>Expensive,primarily synthetic powders that in solid form have lowmachinability and/or high material removal rate</td><td>Low to high cost, organic or synthetic materials that havegood machinabilityand naturally occur in solid form to be used in subtractive processes</td></tr></table></body></html>

Several researchers (see, e.g., [8], [22], [40]) have observed that the discussion on whether to use CM- or AM-technologies is not fundamentally exclusive, as hybrid production set-ups exist. AM may be especially suitable in complementing mass production in companies that have large capital stocks or heterogeneous production lines, with long bills of materials [41]. A survey by Schniederjans [42] shows that major of users of AM-technology in companies are rapid prototyping (RP) and R&D –activities. Other uses in flexible production systems are rapid tooling (RT) and rapid manufacturing (RM) [31], [43], [44]. For a detailed list of current industry applications of additive manufacturing, we suggest [19], [21], [26].

There seem to be two main driving paradigms for the current industrial interest in AM. The first can be called an automation-driven “industry $4 . 0 ^ { 9 }$ -paradigm, which includes the idea of small scale, localized, data-driven factories with resource-efficient, on-demand production capabilities [45]–[48]. The second is a BM paradigm shift of moving from selling physical products to selling a product with a service - that is product-service systems (PSS). Roth [49] suggests, that the technology bundle of computers and 3Dprinting has the potential to make the AM-technology revolutionary. Examples of AM include the manufacturing of dental/medical prostates and prostate spare parts, which are a low-volume, high-cost, customized products, with singular demand patterns [19], [36]. Rehnberg and Ponte [36] envision logistics companies printing products on location, instead of physically moving them from one place to another. An idea of local retail shops with 3D-scanning equipment to customize home-delivered products has been also proposed [50]. In this vein, several authors [10], [51], [52] write about mass individualization of products as the next phase of mass customization.

From the industrial systems perspective, according to [17], [23] AM decreases the minimum efficient technical scale (METS) of manufacturing, which usually is the main driver when making location decisions of production facilities. Final products can be manufactured from raw materials in one location [36], [37], which means replacing many of the labor-intensive work-phases connected to dealing with intermediate products [17], [23]. Bogers and others [1] call these supply chains “glocalized” in order to refer to their local self-sufficiency, but global implementation.

If the “print anything” -promise becomes reality, the ease of manufacturing by AM raises serious concerns about intellectual property rights (IPR) - not to mention about the possibility to perform reverse engineering with 3D-scanners [1], [9]–[11], [17]. Technically, there are still major obstacles that hinder a universal move towards AM-based mass production – these include the number of available materials, print-outs size limitations, and the cost of printing [17], [35], [36]. At this time only a fraction of existing metal alloys are suitable for AM [26] and the introduction of new materials is often inhibited by patents [17], [43]. Furthermore, most AM-based products still require surface finishing [1], [15], [16] and unresolved issues with mechanical properties (e.g. porosity and microstructure) exist that make AM un-suitable for some high-end applications [25], [26], [31]. Currently, there is a lack of process standards [9], which further emphasizes the concerns about safety, reliability, and quality of the AM processes and of the final products.

From industrial applications towards open business models in a sharing economy?

Today’s AM scene can broadly be divided into an industrial segment with state-of-the art metal/composite printing machinery, operating in business environments with competition and proprietary IPR (patents, bilateral contracts) and to a hobbyist-sector that is typically based on using relatively cheap, plastic filament -based printers and embracing sharing-based and peer-to-peer (P2P) -type economies that exist in an open networked setting (see the discussion in, e.g., [10], [53]). Several authors [10], [24], [43] suggest that AM will evolve from these applications towards distributed manufacturing facilities, where some type of “print shops” will serve as an intermediary form of manufacturing.

The actual potential of AM to change business paradigms remains heavily debated [15], [24]. The timing of when such a change might take place has also raised a lot of discussion. The jury is still out on the questions of when (and if) online 3DP-platforms, where users can share and download product designs, will become a viable form of distribution of industrial-grade products, and whether they will ever become a serious business opportunity. The inability to give answers to these questions may suggest that there is a chance that AM-technology may remain a mere addition to the already existing manufacturing paradigms.

Despite the technological buzz around AM and its potential groundbreaking effects to selected industries, the current engineering-focused literature runs short on contributions related to business-issues [9], [54]. Gartner and others [13] criticize the existing surveys of AM-technology experts (entrepreneurs) for being inclined towards positive scenarios and point to (clear) conflicts of interest. Based on the evaluation of technology disruptiveness Hahn & al. [9] observe that the current literature on the topic consists mainly of consultant reports and practitioner reviews that lack a serious academic research focus. These underline the importance of this paper’s critical, fact-based review approach that is aimed at constructing four possible scenarios of the future of additive manufacturing.

The remainder of this paper continues with the literature review and first presents the materials and methods used, then delving into the results of the systematic literature review. The paper is closed with conclusions and discussion.

# 2. Data and methodology

We use a systematic literature review approach. A keyword search from within Scopus (63 hits) and Web of Science (31) abstract and citation databases was performed in May 2019. The search string topic contained articles with either [3d-printing, additive manufacturing] together with at least one of the following topics [business model, value chain, capital investment, economic model, market model]. The search was limited to journal articles written in English. The search resulted in 94 articles of which 45 remained for further analysis after screening out the overlapping and irrelevant results. Backward tracking of relevant works, based on references in the initial set, yielded additional 33 papers. Thus, 78 $( 4 5 + 3 3 )$ works were included in the set used.

![](images/30540003b765d184cf4b3c7330755ae1afd0aeb1401e6b6be5019422475879b6.jpg)  
Figure 1. Year-by-year statistics of published literature in the reviewed set of literature; the estimate for 2019 is based on a linear forecast (light color).

# Quantitative analysis

Ryan and others [38] pinpoint the rising interest on the business related topics in AM to year 2009, when the expiration of a key technology patent in plastic printing1  gave a boost to publishing papers with an application oriented focus. The amount of existing literature is scarce and we can state that business oriented research of AM is an emerging topic at the time of writing this review (Figure 1). Currently there are no dedicated journals concentrating on the economics of AM: Table 2 shows that a relatively high number of journals have published on economic aspects of AM (also observed in [20]). The topical range of the said journals is wide and ranges from engineering to future-research - this may be part of the explanation of why understanding the future business potential and significance of AM/3DP seems to be scattered also in the scientific community as a whole.

Table 2. Publications by journal in the reviewed literature, journals with two or more publications included   

<html><body><table><tr><td>Publication forum</td><td>Ⅱ</td></tr><tr><td>Journal of Manufacturing Technology Management</td><td>9</td></tr><tr><td>Technological Forecasting and Social Change</td><td>9</td></tr><tr><td>International Journal of Advanced Manufacturing Technology</td><td>5</td></tr><tr><td>International Journal of Physical Distribution &amp; Logistics Management</td><td>4</td></tr><tr><td>Business Horizons</td><td>3</td></tr><tr><td>International Journal of Production Economics</td><td>3</td></tr><tr><td>Journal of Cleaner production</td><td>3</td></tr><tr><td>Conference</td><td>2</td></tr><tr><td>Energy Policy</td><td>2</td></tr><tr><td>IFAC-PapersOnLine</td><td>2</td></tr><tr><td>Procedia CIRP</td><td>2</td></tr><tr><td>Rapid Prototyping Journal</td><td>2</td></tr><tr><td>Research-Technology Management</td><td>2</td></tr><tr><td>Supply Chain Management</td><td>2</td></tr><tr><td>Others</td><td>28</td></tr><tr><td>TOTAL</td><td>78</td></tr></table></body></html>

# Qualitative analysis

Sasson and Johnson [41], speak of a polarized conception of $3 D P$ , where the popular media is dominated by a view of industrial revolution and scientific literature is more conservative, highlighting the specialized nature of applications. On the other hand, as observed by [36], many of the business related scientific contributions on AM revolve around the revolutionary effects. One reason for this contradictory perception regarding the business-focused AM-literature, is the gigantic amount of references $\mathrm { \Delta } n > 1 2 0 0$ on June 2019) to a futuristic work of Berman [10], which, despite its compelling title and merits in storytelling, is largely based on non-scientific sources. This observation that we share with [9], does not only concern the paper by Berman, but also many of other articles in which a remarkably large number of references to expert reports and company websites is included, without any discussion about their potential reliability issues.

The AM-literature covered in this paper is listed in Table 3. Contributions are labeled on the basis of research type (quantitative/qualitative) and method including four categories: empirical, exploratory, (literature) review, and simulation. We evaluate, whether the view taken in the research is either incremental or disruptive and whether the BM-paradigm addressed represents open or closed business models.

Table 3. Summary of literature on business models of AM covered.

[see end of the manuscript]

Four levels of studies are identified (Table 3) from user entrepreneur; industrial system (production process); (individual) company level, and global having an industry-wide focus, or broader. The research topics are divided into:

feasibility studies, which revolve around the economic returns of an AM-investment, e.g., equipment investment calculations; business models on how to monetize the capabilities of technology and retain value; supply chain management contributions focus on the (often physical) deployment of AM to harness its benefits in terms of business value; value chain issues is a meta-level discussion of the supply chains category involving larger industry-wide considerations; sustainability deals with the environment, health, quality and safety (EHQS) aspects of business; technology and software platforms categories are self-explainable.

# Classifying the literature

As discussed above, we divide the literature in to four parts, illustrated in Figure 2, to structure this review into a reader-friendly format. This is not a new typology: other four field classifications concerning different aspects of AM can be found in [1], [3], [11], [35], [51], [55]–[58]. The used classification is loosely based on the business-model type and the extent of disruptiveness of the envisioned development and a similar framework is previously used in [11].

Figure 2. Four-field classification used in this review   

<html><body><table><tr><td colspan="2">BUSINESS MODEL Open</td><td rowspan="2">Disruptive development towards open</td><td rowspan="2">DEVELOPMENT</td></tr><tr><td>models</td><td>Incremental development towards open business business models</td></tr><tr><td>Incremental</td><td>Incremental development towards closed business models</td><td>Disruptive development towards closed business models</td><td> Disruptive</td></tr></table></body></html>

When it comes to technological diffusion, incremental innovations may lead to radical outcomes and radical innovations may not have disruptive effects on the markets (see discussion, e.g., [24], [59]). Therefore, for the sake of comprehensiveness of this review, we see it mandatory to address all the possibilities, although the lately published expert surveys [11], [60] seem to indicate that the not-so-radical scenarios are the most likely to materialize. The four different, non-exclusive directions of development (Figure 2) are assumed to have the following key characteristics:

1) Closed incremental: AM-equipment is, or will become a natural part of flexible manufacturing and supply chains. AM is used for complementing mass manufacturing in low-volume parts   
2) Closed disruptive: AM gains ground as a new manufacturing paradigm and bundles of AMequipment replace current industrial systems of mass manufacturing. Existing firms use AMtechnology in radical ways and business models have to be re-invented   
3) Open incremental: desktop-grade consumer printers become more advanced and remain available for large masses. Consumers produce plastic/metal parts primarily for their own use, or for P2P sales, elevating the role of online sharing platforms.   
4) Open disruptive: networks of consumers’ desktop-printers replace many of the centralized manufacturing plants. Prosumers (producer $^ +$ consumer) overtake manufacturing activities in the existing GVCs

# 3. Review of literature

# 3.1 Literature based on the premise of closed-incremental development

Incremental development, where AM-technology serves as a part of larger technological system [59], enables two major application areas: first, to complement mass-production of simple, or AM-enhanced, low-volume parts [41] and second, to produce digitally stored spare parts on-demand to boost PSS-business models [61]–[63]. In case of uni-/bipolar GVCs (such as aerospace / automotive) [36], the successful adoption of AM in the leading firms can actually leverage existing power structures, as companies on the top can reduce their needs for specialized equipment.

# Part manufacturing

Shifting production of individual parts to AM requires (re-)design, which is addressed in [23], [36], [37], [62], [64], [65] and it is one of the major cost factors in the economics of AM, as is demonstrated in empirical studies [64], [65]. The real life example in [59] shows, however, that technical feasibility issues can be overcome, when monetary benefits of AM are clear. Achillas and others [44] develop a decision making tool for evaluating the feasibility of AM-applications in a production facility and related to this, the cost accounting aspects of AM are dealt with by [30], [43], [66].

Today, IPR-issues incentivize companies to keep AM-activities in-house and not allowing contracted service-providers to reach economies of scale (see discussions [36], [41]), and “industry-grade” AM-part suppliers operate from centralized low-cost locations with a focus on complementing clients’ manufacturing capabilities [50]. A study of existing business in industrial 3DP-services [43] shows that most of these AM-service providers produce components or prototypes and among them, printing complex metal parts yield the highest revenues. In 2012, Hahn and others [9] studied 79 technology start-ups and report that companies selling (tangible) AM-equipment gain the highest attention among investors, instead of (intangible) printing services.

# Spare part service

The promise of AM in the spare part servicing industry lies in reduced service lead-times and diminished inventory obsolescence [61]. Matsumoto and others [22] see remanufacturing of selected high value (metal)

parts as a future key application in PSS-models. These are currently limited to technically advanced industrial products [22], as more widespread adoption is inhibited by the fear of losing-out on short-term profits and by customers who prefer traditional forms of ownership [67]. For a general level discussion on maintenance applications of AM-technology, see [8], [22], [68].

The available simulation studies on the topic [69], [70] support the idea of AM-based spare parts service, but aggregating demand for economic feasibility remains an issue. Also, the inadequate printing speed, AM-availability, and problems with steady product quality negatively affect the diffusion of AMtechnologies [61], [62], [71]. The feasibility of a digitally distributed spare parts business models for OEMs (Original Equipment Manufacturers) remains debated (see [52]).

If / when AM becomes a viable method for spare parts manufacturing, the OEMs will either digitize and publish component data or let replicas of uncertain quality exist [41]. We believe that instead of laissezfaire policies, OEM-controlled spare parts produced with AM and part remanufacturing will gain ground in the closed market settings and create business potential for standardized industrial data-sharing platforms, where several OEMs can securely distribute spare part designs to a network of trusted 3DPservice providers (see discussion also in [62]). This development could be further sped up, if the current AM-technology development would turn into a competition in producing high-margin spare parts (see [56]). In the long term, a consolidation of service providers would be likely. By having platform partnership(s) with the forthcoming big player(s) with the state-of-the-art capabilities, the OEMs could be able to divest some of their fixed assets, while stile ensuring the availability of spare parts (see also [50]).

# 3.2. Literature based on the premise of closed-disruptive development

The closed disruptive scenario takes the above described development further to where the rise of AMtechnologies in the supply chains (SCs) changes the current equilibrium of GVCs. Two alternative paths to this are visible in the literature: a path of increasingly localized production [8], [34] and, proposed by [41], a path, where low-volume items are manufactured in centralized AM locations called “3DP-supercenters”. The first line of thought is based on the ability of AM to leverage simultaneous production and consumption of goods without costs. At the time of this review, this scenario is not supported by technological capabilities and is dubious from the point of view of the requirements for investment payback [71]. The second idea concerning centralized AM offers economies of scale [41]. In a review of Ryan and others [38] that identified a total of 201 alternative supply chain-scenarios of AM a “factory” of this type was the least considered scenario. Ryan and others add that these investments could further increase profitability, if their idle capacities were harnessed in printing make-to-stock items alongside customized products. [11], [24], [41], [46] contemplate the possibility of commoditized AM infrastructure that enables companies to reposition themselves in the GVCs (e.g., design only), or to industry sectors previously out of their reach [36]. On the other hand, the wide availability of manufacturing infrastructure could deteriorate the position of market incumbents.

The trade-off between manufacturing flexibility (full AM) and controllability (full CM) is discussed, e.g., in [57], [72]. Nyman and others [73] describe beneficial characteristics of AM for different types of SCs. Mellor and others [74] provide a general framework to evaluate company-specific benefits from AM. [58] present a systemic approach to identify potentially valuable supply chain applications. Schniederjans [42] investigates the role of top management in AM-adoption through a survey $\scriptstyle ( \mathrm { n } - 2 7 0 )$ ) and indicate a link between the positive attitudes of managers and the companies’ “intent to adopt”, while this intention remains uncorrelated with the actual adoption rates.

Supply chain feasibility simulations have been presented by [75] in a context of two-stage facility location problem, Chiu & Lin [76] write about the effects of AM in lamp manufacturing, and Minguela-Canela and others [35] inspect suitable production-strategies for products with different demand patterns. Jia and others [77] simulate the feasibility of an on-demand chocolate manufacturing operation.

# 3.3 Summary of development in closed business models

In the case of established business environments with other complementary assets (as defined by [78]) in place, the changes brought by the AM-technology may not be radical. As Sandström [59] showed the hearing-aid manufacturing industry incrementally adopted AM-technology without causing any changes in the competitive landscape. Therefore, we see the main window of opportunity in this scenario to exist for innovative AM-service providers in the business of OEMs’ spare part service which can develop later into lucrative BMs.

![](images/2bcc96f07d4f86ca716376d91a3ab5befe45e84f98950d6d4e9f90846495ea32.jpg)  
Figure 3. Main directions within the closed BM-paradigm, where dashed lines represent the less probable direction of development in the near future.

Our summary of the envisioned development in closed BMs is presented in Figure 3. The possible disruptive changes beyond 3DP-supercenters could inherently alter the structure of existing GVCs in the closed BMs [79]. This according to [17], [23] would shorten the raw material supply chains and, in a larger perspective, these types of shifts could have de-stabilizing effects in the societies that base their global trade on raw materials and that do not enjoy the benefits of technological developments in AM (see [80], [81]). Therefore, according to [13], a quick adoption of AM-technologies should be preferred in the industry and national levels.

# 3.4 Literature based on the premise of open-incremental development

The idea of democratization and disintermediation of production and services is outlined in [82]. In the open-incremental scenario local fab-labs create possibilities for peer-to-peer production-based supply chains and bring down the barriers of entrepreneurship by enabling access to 3DP-equipment [7], [13]. In the software industry open-source development of products has already demonstrably been shown to be a viable business model [39] and by contrasting it to 3D-printing, one finds a natural way of discussing open business models for manufacturing. The manufacturing that takes place under this paradigm has been called open-source cottage industry [83] and is widely discussed in [84].

# Peer-to-peer manufacturing

Consumers can already share their own designs in platforms for money [1]. High consumer involvement in manufacturing has several points of concern related to the willingness to pay for self-designed products and to finding reasonable revenue and pricing models (see discussion, e.g., in [24]). Studies of [71], [85], highlight the home-users’ do-it-yourself mentality as a primary facilitating factor for home printing, instead of a money motive. Regardless of the economic feasibility, the adoption of desktop printers with increasing quality at homes makes it possible to print parts, which translates to de-skilling and democratizing the production of simple objects [8], [15], [53]. It is boldly claimed by [83] that buying a cheap RepRap printer for an average household is a profitable investment assuming only 20 printed items per year.

Today’s consumer-grade equipment is mainly based on the cheapest available plastic printing technology2 one-color objects with relatively good mechanical properties [1], and a varying dimensional accuracy [86] requiring nuanced variable optimization (e.g., humidity, room airflows) for acceptable printing results [29]. Implementing full-fledged, complex 3DP-designs requires new types of skills and engineering software [8], [15], [53], [71] and for this purpose [86], [87] formulate ideas of easy-to-use design software.

Laplume and others [88] develop the idea of a 3D-print shop in a semi-empirical study. They assume a production on-demand BM and a number of configurations of consumer-grade $\mathrm { F D M } ^ { 2 }$ -printers that is, printer farms with several centrally-controlled machines [89]. It has been suggested that printer farms would accrue economically sustainable annual revenues [88]. The study by [90] suggests that consumergrade FDM printers could be sped-up as much as $7 \mathrm { x } \mathrm { - } 1 0 \mathrm { x }$ with very small additional investments.

Holzmann and others [3] evaluate existing user-entrepreneur BMs suggesting that the most valuable options are likely to be in on-line services related to consulting, selling of product designs, and in locally providing 3DP-capacity. A look into the BMs of 73 fab-labs [7] show that the fab-labs who sell on-line services were able to sell more expensive and higher quality products than their physical counterparts. Another survey [91] indicates that today fab-lab operations are still heavily subsidized, because of the lack of solid BMs.

# 3.5 Literature based on the premise of open-disruptive development

# Home manufacturing

Berman [10] proposes a scenario for 3DP, where the content to 3D-printers is downloaded and printed as routinely as digitalized contents of music, books, and movies are consumed today. From the manufacturing companies’ point of view, giving an opportunity to customers for un-supervised production and/or customization of products means also silently approving the used designs for safety and durability. Huang and others [20] note that there are unaddressed safety hazards related to the use of chemicals at home. The final products, according to [33], should also comply with regulations for the safety of materials - especially if products are made of recycled filaments coming from various sources. One emerging field of AMresearch is the use recycled plastics, or secondary product streams as raw materials [8], [23].

Petrick & Simpson [92] ask whether, in this case, we should even assume consistent product quality, if mainly unique products are made. Product failure liability issues are also of relevance, as there is no established regulation for home-printed products [11], [88]. Possible company strategies to deal with opensource communities are discussed in [39].

# Closed-loop economies

If the products were made with AM without long logistic chains, [23], it should be easy to trace material consumption of individual components enabling efficient recycling. Locally the recycling of filaments reduces landfill, transportation, and $\mathrm { C O } _ { 2 }$ -emissions in both production and in transportation [33]. There is however a lack of open data with regards to the material specifications of filaments and the 3DP-equipment manufacturers, the focal firms of the industry, mainly use their own proprietary materials to sell filament cartridges [33] although some change towards ecosystem-based BMs has been reported by [93].

Accumulated environmental effects of AM remain debated - the issue is complex and requires a systemic perspective to evaluate the overall effects [8], [9], [20], [23], [68], [94]–[96]. Although AM reduces the direct consumption of energy and of material in the manufacturing process, the production of printable substances can be a major resource and energy consumer (see, e.g., [8]). Related to this topic [55] propose an energy consumption reduction range of $5 \text{‰}$ worldwide and [79] arrive at a rough average reduction figure of $- 5 \%$ . Circular economy roadmap and research agenda enabled by AM is presented in [23], [68].

# 3.6 Summary of development in open business models

The realism of disruptive home manufacturing scenarios remains questionable. Rogers and others [50] point to local on-demand manufacturing and the role of on-line marketplaces as strong competitors, moreover [97] reminds that mastering of the various AM-techniques is far more demanding than copying and listening to music files. Although a dramatic disruption of manufacturing seems quite unrealistic at this time, [82] remind us that in the advent of personal computers and the Internet, no one was able to imagine their future changing power and the role of software industry in the modern society.

In the case of more conservative incremental development, some believe that the existing brands will continue to shelter market incumbents [59], while others put their faith on signaling the value of customization over branding [84]. Also a middle road exists and [39] suggests that the pivotal role of opensource communities could be in the manufacturing of products without adequate commercial potential and thus not in competing with companies involved in large scale production. If user-entrepreneurs were to start gaining significant market shares [46], [77], [88] anticipate rapid 3DP adoption in the retail stores that already know how to put into practice the use of customer data. Over the long haul, we suggest that the lack of capital and complementary assets will become a pivotal issue with regards to the success of userentrepreneurs. As [17] point out, metal printing equipment alone can today cost over $5 0 0 \mathrm { k } \Phi$ making it unreachable to households and even small print shops. Our summary of the development is visualized in Figure 4.

![](images/7b788cb5ef809ce5e09dac7447521e4ee0872bcec87005f643aa3ff892a294e6.jpg)  
Figure 4. Main directions within the open BM-paradigm. Dashed line indicates the improbable phases in the development.

# 3 Summary and conclusions

In this review we have presented and categorized the academic literature on AM business models. We have divided the material into to four categories, based on the type of BM described in the studied papers and based on the nature of the effect AM was perceived to have on the business of manufacturing. We feel that the classification sheds light on the literature on AM business models also on a meta-level - at the time of this review, discussion and visions range from a global economic revolution of manufacturing to engineering level studies with the feasibility of one piece of equipment as the centerpiece of interest.

From an author point of view, it would be satisfying to be able to provide a unifying theory, or the great synthesis of the studied topic – here we have to contend with the belief that most likely different streams with diverse visions of the future and the role of additive manufacturing will continue to still exist for some time. It is likely that only hard fact-based evidence from real-world cases will consolidate the literature and the vision of the many players on the field to a consensus. In Table 4 we present a summary of the findings of our exploration and review of the literature.

Table 4. Summary of the findings.

<html><body><table><tr><td>Applications,issues industries/BM-type</td><td>Closed Incre mental</td><td>Closed Dis ruptive</td><td>Open Incre me ntal</td><td>Open Dis ruptive</td></tr><tr><td>Applications and /or business openings</td><td>AM-equipmentoseplcd sinleR-positioin f enufaeturers Spare parts and maintenace applications Trusted design library platforms</td><td>Commoditized manufacturing infrastructure and glocalized</td><td>P2P manufacturing in local printshops or via online platforms Fab-labs</td><td>Home manufacturing Closed-loop economies</td></tr><tr><td>Issus (inadition to</td><td>by 3DP-service providers Technical possibilities Lackofincenives i AM-: Lack of economic feasibity</td><td>Supply chain complexities</td><td>IPR Lack of skills and knowledge Lack of revenue models</td><td>Regulation and liability issues</td></tr><tr><td>Indus tries</td><td>High value industries,where AM Not yet existing (requires solving provides competitive advantage when used as a part of a overall product (eco)system</td><td>of issues)</td><td>Industry niches or nascent industries without (yet)adequate commercial potential</td><td>Not yet existing (requires solving of issues)</td></tr></table></body></html>

Based on this review and without considering unforeseen technological breakthroughs, AM-technologies remain a complementing technology for selected set of products and the economic potential of AMtechnology is still based on conceptual studies that at the time of writing have no economic reality, implying a gradual adoption on the basis of economic constraints (see also [1], [63]). In the case of sudden rapid technological development, [80] anticipate a rising regulation of technology, leading to barriers to fast global adoption. We find that the incremental AM-adoption in closed business environments will likely lead to 3DP-service providers that operate via OEM-controlled digital platforms to support spare parts service. In essence, the open business models promoting the sharing of IPR (acquired through paid efforts) and ignorance of quality requirements do not resonate with the common sense of either the manufacturers or the end-users.

# ACKNOWLEDGEMENTS

This research acknowledges the funding from Finnish Strategic Research Council - Manufacturing 4.0 – project decision no. 313396

# REFERENCES

[1] M. Bogers, R. Hadar, and A. Bilberg, “Additive manufacturing for consumer-centric business models: Implications for supply chains in consumer goods manufacturing,” Technol. Forecast. Soc. Change, vol. 102, pp. 225–239, 2016.   
[2] C. Baden-Fuller and S. Haefliger, “Business Models and Technological Innovation,” Long Range Plann., vol. 46, no. 6, pp. 419–426, 2013.   
[3] P. Holzmann, R. J. Breitenecker, A. A. Soomro, and E. J. Schwarz, “User entrepreneur business models in 3D printing,” J. Manuf. Technol. Manag., vol. 28, no. 1, pp. 75–94, 2017.   
[4] C. Öberg, T. Shams, and N. Asnafi, “Additive Manufacturing and Business Models: Current

Knowledge and Missing Perspectives,” Technol. Innov. Manag. Rev., vol. 8, no. 6, 2018.

[5] V. Verboeket and H. Krikke, “The disruptive impact of additive manufacturing on supply chains: A literature study, conceptual framework and research agenda,” Comput. Ind., vol. 111, pp. 91– 107, 2019.   
[6] S. Flammini, G. Arcese, M. C. Lucchetti, L. Mortara, S. Flammini, and M. C. Lucchetti, “Business model configuration and dynamics for technology commercialization in mature markets,” Br. Food J., vol. 119, no. 11, pp. 2340–2358, 2017.   
[7] L. Mortara and N. Gontran, “Through entrepreneurs’ eyes: the Fab-spaces constellation,” Int. J. Prod. Res., vol. 54, no. 23, pp. 7158–7180, 2016.   
[8] S. Ford and M. Despeisse, “Additive manufacturing and sustainability: an exploratory study of the advantages and challenges,” J. Clean. Prod., vol. 137, pp. 1573–1587, 2016.   
[9] F. Hahn, S. Jensen, and S. Tanev, “Disruptive Innovation vs Disruptive Technology : The Disruptive Potential of the Value Propositions of 3D Printing Technology Startups,” Technol. Innov. Manag. Rev., no. December, pp. 27–36, 2014.   
[10] B. Berman, “3-D printing: The new industrial revolution,” Bus. Horiz., vol. 55, no. 2, pp. 155–162, 2012.   
[11] R. Jiang, R. Kleer, and F. T. Piller, “Predicting the future of additive manufacturing: A Delphi study on economic and societal implications of 3D printing for 2030,” Technol. Forecast. Soc. Change, vol. 117, pp. 84–97, 2017.   
[12] B. C. Gross, J. L. Erkal, S. Y. Lockwood, C. Chen, and D. M. Spence, “Evaluation of 3D Printing and Its Potential Impact on Biotechnology and the Chemical Sciences,” Anal. Chem., vol. 86, no. 7, pp. 3240–3253, Apr. 2014.   
[13] J. Gartner, D. Maresch, and M. Fink, “The Potential of Additive Manufacturing for Technology Entrepreneurship: An Integrative Technology Assessment,” Creat. Innov. Manag., vol. 24, no. 4, pp. 585–600, 2015.   
[14] C. Ross, W. Crittenden, and V. L. Crittenden, “3-D PRINTING: Big potential, little adoption,” Ind. Manag., no. July/August, pp. 12–16, 2016.   
[15] C. Weller, R. Kleer, and F. T. Piller, “Economic implications of 3D printing: Market structure models in light of additive manufacturing revisited,” Int. J. Prod. Econ., vol. 164, pp. 43–56, 2015.   
[16] K. V. Wong and A. Hernandez, “A Review of Additive Manufacturing,” ISRN Mech. Eng., pp. 1– 10, 2012.   
[17] A. Laplume, B. Petersen, and J. M. Pearce, “Global value chains from a 3D printing perspective,” J. Int. Bus. Stud., vol. 47, no. 5, pp. 595–609, 2016.   
[18] W. Gao et al., “The status, challenges, and future of additive manufacturing in engineering,” Comput. Des., vol. 69, pp. 65–89, Dec. 2015.   
[19] M. Attaran, “The rise of 3-D printing: The advantages of additive manufacturing over traditional manufacturing,” Bus. Horiz., vol. 60, no. 5, pp. 677–688, 2017.   
[20] S. H. Huang, P. Liu, A. Mokasdar, and L. Hou, “Additive manufacturing and its societal impact: A literature review,” Int. J. Adv. Manuf. Technol., vol. 67, no. 5–8, pp. 1191–1203, 2013.   
[21] V. Petrovic, J. Vicente Haro Gonzalez, O. Jordá Ferrando, J. Delgado Gordillo, J. Ramon Blasco Puchades, and L. Portoles Grinan, “Additive layered manufacturing: Sectors of industrial application shown through case studies,” Int. J. Prod. Res., vol. 49, no. 4, pp. 1061–1079, 2011.   
[22] M. Matsumoto, S. Yang, K. Martinsen, and Y. Kainuma, “Trends and research challenges in remanufacturing,” Int. J. Precis. Eng. Manuf. Technol., vol. 3, no. 1, pp. 129–142, 2016.   
[23] M. Despeisse et al., “Unlocking value for a circular economy through 3D printing: A research agenda,” Technol. Forecast. Soc. Change, vol. 115, pp. 75–84, 2017.   
[24] T. Rayna and L. Striukova, “From rapid prototyping to home fabrication: How 3D printing is changing business model innovation,” Technol. Forecast. Soc. Change, vol. 102, pp. 214–224, 2016.   
[25] T. Caffrey and T. Wohlers, “An Additive Manufacturing Update,” Appl. Des., no. May, pp. 27–29, 2016.   
[26] T. D. Ngo, A. Kashani, G. Imbalzano, K. T. Q. Nguyen, and D. Hui, “Additive manufacturing (3D printing): A review of materials, methods, applications and challenges,” Compos. Part B Eng., vol. 143, pp. 172–196, 2018.   
[27] I. Gibson, D. W. D. W. Rosen, and B. Stucker, Additive Manufacturing Technologies: Rapid Prototyping to Direct Digital Manufacturing. Springer, 2009.   
[28] T. Wohlers and T. Gornet, “History of additive manufacturing,” Wohlers Rep. 2014, p. 34, 2014.   
[29] H.-J. Steenhuis and L. Pretorius, “Consumer additive manufacturing or 3D printing adoption: an exploratory study,” J. Manuf. Technol. Manag., vol. 27, no. 7, pp. 990–1012, 2016.   
[30] G. Manogharan, R. A. Wysk, and O. L. A. Harrysson, “Additive manufacturing-integrated hybrid manufacturing and subtractive processes: Economic model and analysis,” Int. J. Comput. Integr. Manuf., vol. 29, no. 5, pp. 473–488, 2016.   
[31] Wohlers, “Additive Manufacturing Technology Roadmap for Australia,” 2011.   
[32] M. Baumers, P. Dickens, C. Tuck, and R. Hague, “The cost of additive manufacturing: Machine productivity, economies of scale and technology-push,” Technol. Forecast. Soc. Change, vol. 102, pp. 193–201, 2016.   
[33] A. Garmulewicz, M. Holweg, H. Veldhuis, and A. Yang, “Disruptive Technology as an Enabler of the Circular Economy: What Potential Does 3D Printing Hold,” Calif. Manage. Rev., vol. 60, no. 3, pp. 112–132, 2018.   
[34] M. Hannibal and G. Knight, “Additive manufacturing and the global factory: Disruptive technologies and the location of international business,” Int. Bus. Rev., vol. 27, no. 6, pp. 1116– 1127, 2018.   
[35] J. Minguella-Canela et al., “Comparison of production strategies and degree of postponement when incorporating additive manufacturing to product supply chains,” Procedia Manuf., vol. 13, pp. 754–761, 2017.   
[36] M. Rehnberg and S. Ponte, “From smiling to smirking? 3D printing, upgrading and the restructuring of global value chains,” Glob. Networks, vol. 18, no. 1, pp. 57–80, 2018.   
[37] B. P. Conner et al., “Making sense of 3-D printing: Creating a map of additive manufacturing products and services,” Addit. Manuf., vol. 1–4, pp. 64–76, Oct. 2014. M. J. Ryan et al., “3D printing the future : scenarios for supply chains reviewed,” Int. J. Phys. Distrib. Logist. Manag., vol. 47, no. 10, pp. 992–1014, 2017.   
J. P. J. de Jong and E. de Bruijn, “Innovation Lessons From 3-D Printing,” MIT Sloan Manag. Rev., vol. 54, no. 2, pp. 43–52, 2013.   
G. Tosello et al., “Value chain and production cost optimization by integrating additive   
manufacturing in injection molding process chain,” Int. J. Adv. Manuf. Technol., vol. 100, no. 1, pp. 783–795, 2019.   
A. Sasson and J. C. Johnson, “The 3D printing order: variability, supercenters and supply chain reconfigurations,” Int. J. Phys. Distrib. Logist. Manag., vol. 46, no. 1, pp. 82–94, 2016.   
D. G. Schniederjans, “Adoption of 3D-printing technologies in manufacturing: A survey analysis,” Int. J. Prod. Econ., vol. 183, no. October 2016, pp. 287–298, 2017.   
M. Khorram Niaki and F. Nonino, “Impact of additive manufacturing on business   
competitiveness: a multiple case study,” J. Manuf. Technol. Manag., vol. 28, no. 1, pp. 56–74, 2017.   
C. Achillas, D. Aidonis, E. Iakovou, M. Thymianidis, and D. Tzetzis, “A methodological framework for the inclusion of modern additive manufacturing into the production portfolio of a focused factory,” J. Manuf. Syst., vol. 37, pp. 328–339, 2015.   
S. K. Rao and R. Prasad, “Impact of 5G Technologies on Industry 4.0,” Wirel. Pers. Commun., vol. 100, pp. 145–159, 2018.   
R. Strange and A. Zucchella, “Industry 4.0, global value chains and international business,” Multinatl. Bus. Rev., vol. 25, no. 3, pp. 174–184, 2018.   
H.-G. Kemper, P. Fettke, T. Feld, and M. Hoffmann, “Industry 4.0,” Bus. Inf. Syst. Eng., vol. 4, pp. 239–242, 2014.   
D. L. M. Nascimento et al., “Exploring Industry 4.0 technologies to enable circular economy practices in a manufacturing context: A business model proposal,” J. Manuf. Technol. Manag., vol. 30, no. 3, pp. 607–627, Nov. 2018.   
S. Roth, “The cash is in the medium, not in the machine: toward the golden moments of 3D printing,” Int. J. Manuf. Technol. Manag., vol. 32, no. 1, 2018.   
H. Rogers, N. Baricz, and K. S. Pawar, “3D printing services: classification, supply chain implications and research agenda,” Int. J. Phys. Distrib. Logist. Manag., vol. 46, no. 10, pp. 886– 907, 2016.   
M. Savastano, C. Amendola, F. D’Ascenzo, and E. Massaroni, “3-D Printing in the Spare Parts Supply Chain: An Explorative Study in the Automotive Industry,” in Lecture Notes in Information Systems and Organisation, vol. 18, 2016.   
G. Würtz, H. Lasi, and D. Morar, “Additive Manufacturing – enabling technology for lifecycle oriented value- increase or value-decrease,” Procedia CIRP, vol. 33, pp. 394–399, 2015.   
Royal Academy of Engineering, “Additive Manufacturing: Opportunities and Constraints,” 2013. K. Muita, M. Westerlund, and R. Rajala, “The Evolution of Rapid Production: How to Adopt Novel Manufacturing Technology,” IFAC-PapersOnLine, vol. 48, no. 3, pp. 32–37, 2015. L. A. Verhoef, B. W. Budde, C. Chockalingam, B. García, and A. J. M. Van Wijk, “The effect of

additive manufacturing on global energy demand: An assessment using a bottom-up approach,”

Energy Policy, vol. 112, no. November 2017, pp. 349–360, 2018.   
[56] J. Kietzmann, L. Pitt, and P. Berthon, “Disruptions, decisions, and destinations: Enter the age of 3- D printing and additive manufacturing,” Bus. Horiz., vol. 58, no. 2, pp. 209–215, 2015.   
[57] C. Braziotis, H. Rogers, and A. Jimo, “3D printing strategic deployment: the supply chain perspective,” Supply Chain Manag. An Int. J., Feb. 2019.   
[58] F. Fontana, C. Klahn, and M. Meboldt, “Value-driven clustering of industrial additive manufacturing applications,” J. Manuf. Technol. Manag., vol. 30, no. 2, pp. 366–390, Dec. 2018.   
[59] C. G. Sandström, “The non-disruptive emergence of an ecosystem for 3D Printing - Insights from the hearing aid industry’s transition 1989-2008,” Technol. Forecast. Soc. Change, vol. 102, pp. 160–168, 2016.   
[60] M. P. Pérez-Pérez, E. Gómez, and M. A. Sebastián, “Delphi Prospection on Additive Manufacturing in 2030: Implications for Education and Employment in Spain,” Mater. (Basel, Switzerland), vol. 11, no. 9, p. 1500, Aug. 2018.   
[61] J. Holmström, J. Partanen, J. Tuomi, and M. Walter, “Rapid manufacturing in the spare parts supply chain: Alternative approaches to capacity deployment,” J. Manuf. Technol. Manag., vol. 21, no. 6, pp. 687–697, 2010.   
[62] J. Holmström, J. Partanen, and J. Holmström, “Digital manufacturing-driven transformations of service supply chains for complex products,” Supply Chain Manag., vol. 19, no. 4, pp. 421–430, 2014.   
[63] J. Holmström, M. Holweg, S. H. Khajavi, and J. Partanen, “The direct digital manufacturing (r)evolution: definition of a research agenda,” Oper. Manag. Res., vol. 9, no. 1–2, pp. 1–10, 2016.   
[64] E. Atzeni, L. Iuliano, P. Minetola, and A. Salmi, “Redesign and cost estimation of rapid manufactured plastic parts,” Rapid Prototyp. J., vol. 16, no. 5, pp. 308–317, 2010.   
[65] E. Atzeni and A. Salmi, “Economics of additive manufacturing for end-usable metal parts,” Int. J. Adv. Manuf. Technol., vol. 62, no. 9–12, pp. 1147–1155, 2012.   
[66] C. Lindemann, U. Jahnke, M. Moi, and R. Koch, “Analyzing Product Lifecycle Costs for a Better Understanding of Cost Drivers in Additive Manufacturing,” in 23rd Annual International Solid Freeform Fabrication Symposium–An Additive Manufacturing Conference, 2012, pp. 177–188.   
[67] C. Vezzoli, F. Ceschin, J. C. Diehl, and C. Kohtala, “New design challenges to widely implement ‘Sustainable Product–Service Systems,’” J. Clean. Prod., vol. 97, pp. 1–12, 2015.   
[68] M. Despeisse, M. Yang, S. Evans, S. Ford, and T. Minshall, “Sustainable Value Roadmapping Framework for Additive Manufacturing,” Procedia CIRP, vol. 61, pp. 594–599, 2017.   
[69] S. H. Khajavi, J. Partanen, and J. Holmström, “Additive manufacturing in the spare parts supply chain,” Comput. Ind., vol. 65, pp. 50–63, 2014.   
[70] A. Ghadge, G. Karantoni, A. Chaudhuri, and A. Srinivasan, “Impact of additive manufacturing on aircraft supply chain performance: A system dynamics approach,” J. Manuf. Technol. Manag., vol. 29, no. 5, pp. 846–865, Apr. 2018.   
[71] D. R. Eyers and A. T. Potter, “E-commerce channels for additive manufacturing: an exploratory study,” J. Manuf. Technol. Manag., vol. 26, no. 3, pp. 390–411, 2015. D. Thomas, “Costs, benefits, and adoption of additive manufacturing: a supply chain perspective,” Int. J. Adv. Manuf. Technol., vol. 85, pp. 1857–1876, 2016.   
H. Nyman and P. Sarlin, “From Bits to Atoms: 3D Printing in the Context of Supply Chain Strategies,” in 47th Hawaii International Conference on System Science, 2014, pp. 4190–4199. S. Mellor, L. Hao, and D. Zhang, “Additive manufacturing: A framework for implementation,” Int. J. Prod. Econ., vol. 149, pp. 194–201, 2014.   
A. Barz, T. Buer, and H. D. Haasis, “Quantifying the effects of additive manufacturing on supply networks by means of a facility location-allocation model,” Logist. Res., vol. 9, no. 1, pp. 1–14, 2016.   
M. Chiu and Y. Lin, “Simulation based method considering design for additive manufacturing and supply chain: an empirical study of lamp industry,” Ind. Manag. Data Syst., vol. 116, no. 2, pp. 322–348, 2016.   
F. Jia, X. Wang, N. Mustafee, and L. Hao, “Investigating the feasibility of supply chain-centric business models in 3D chocolate printing: A simulation study,” Technol. Forecast. Soc. Change, vol. 102, pp. 202–213, 2016.   
D. J. Teece, “Profiling from technological innovation: implications for integration, collaboration, licencing and public policy,” Res. Policy, vol. 15, no. February, pp. 285–305, 1986.   
M. Gebler, A. J. M. Schoot Uiterkamp, and C. Visser, “A global sustainability perspective on 3D printing technologies,” Energy Policy, vol. 74, no. C, pp. 158–167, 2014.   
D. R. Gress and R. V. Kalafsky, “Geographies of production in 3D: Theoretical and research implications stemming from additive manufacturing,” Geoforum, vol. 60, no. February, pp. 43–52, 2015.   
F. Matos and C. Jacinto, “Additive manufacturing technology: mapping social impacts,” J. Manuf. Technol. Manag., vol. 30, no. 1, pp. 70–97, Aug. 2018.   
S. Hoover, L. Lee, and S. Hoover, “Democratization and Disintermediation Disruptive   
Technologies and the Future of Making Things,” Res. Manag., vol. 58, no. 6, pp. 31–37, 2015. B. T. Wittbrodt et al., “Life-cycle economic analysis of distributed manufacturing with opensource 3-D printers,” Mechatronics, vol. 23, no. 6, pp. 713–726, 2013.   
C. Cautela, P. Pisano, and M. Pironti, “The emergence of new networked business models from technology innovation : an analysis of 3-D printing design enterprises,” Int. Entrep. Manag. J., vol. 10, no. 3, pp. 487–501, 2014.   
S. Halassi, J. Semeijn, and N. Kiratli, “From consumer to prosumer: a supply chain revolution in 3D printing,” Int. J. Phys. Distrib. Logist. Manag., vol. 49, no. 2, pp. 200–216, 2019.   
M. Fuge, G. Carmean, J. Cornelius, and R. Elder, “The MechProcessor: Helping Novices Design Printable Mechanisms Across Different Printers,” J. Mech. Des., vol. 137, no. 11, p. 111415, 2015.   
J. Gardan, “Definition of users’ requirements in the customized product design through a usercentered translation method,” Int. J. Interact. Des. Manuf., vol. 11, no. 4, pp. 813–821, 2017. A. Laplume, G. C. Anzalone, and J. M. Pearce, “Open-source, self-replicating 3-D printer factory for small-business manufacturing,” Int. J. Adv. Manuf. Technol., vol. 85, no. 1–4, pp. 633–642, 2016.   
[89] P. Skawiński, “The 3D Printer Farm – function and technology requirements and didactic use,” Mechanik, vol. 8–9, pp. 796–799, 2017.   
[90] J. Go and A. J. Hart, “Fast Desktop-Scale Extrusion Additive Manufacturing,” Addit. Manuf., vol. 18, pp. 276–284, 2017.   
[91] G. Santos, F. Murmura, and L. Bravi, “Fabrication laboratories: The development of new business models with new digital technologies,” J. Manuf. Technol. Manag., vol. 29, no. 8, pp. 1332–1357, Aug. 2018.   
[92] I. J. Petrick and T. W. Simpson, “Point of View: 3D Printing Disrupts Manufacturing: How Economies of One Create New Rules of Competition,” Res. Manag., vol. 56, no. 6, pp. 12–16, 2013.   
[93] K. Rong, D. Patton, and W. Chen, “Business models dynamics and business ecosystems in the emerging 3D printing industry,” Technol. Forecast. Soc. Change, vol. 134, pp. 234–245, 2018.   
[94] J. Faludi, C. Bayley, S. Bhogal, and M. Iribarne, “Comparing environmental impacts of additive manufacturing vs traditional machining via life-cycle assessment,” Rapid Prototyp. J., vol. 21, no. 1, pp. 14–33, 2015.   
[95] M. A. Kreiger, M. L. Mulder, A. G. Glover, and J. M. Pearce, “Life cycle analysis of distributed recycling of post-consumer high density polyethylene for 3-D printing filament,” J. Clean. Prod., vol. 70, pp. 90–96, May 2014.   
[96] S. Hankammer and R. Kleer, “Degrowth and collaborative value creation: Reflections on concepts and technologies,” J. Clean. Prod., vol. 197, pp. 1711–1718, 2018.   
[97] M. Appleyard, “Corporate responses to online music piracy: Strategic lessons for the challenge of additive manufacturing,” Bus. Horiz., vol. 58, pp. 69–76, 2015.

# APPENDIX 1.

Table A1. Covered literature summarized from table 3 based on research topic, business model assumption, level of study, research method and the type of study.   

<html><body><table><tr><td>TOPIC</td><td>Ⅱ</td><td>%</td><td>LEVELOFSTUDY</td><td>Ⅱ</td><td>%</td></tr><tr><td>Business models</td><td>23</td><td>29.5</td><td>Company</td><td>28</td><td>35.9</td></tr><tr><td>Value chains</td><td>18</td><td>23.1</td><td>Global</td><td>23</td><td>29.5</td></tr><tr><td>Sustainability</td><td>10</td><td>12.8</td><td>Industrial system</td><td>21</td><td>26.9</td></tr><tr><td>Supply chains</td><td>11</td><td>14.1</td><td>User entrepreneur</td><td>6</td><td>7.7</td></tr><tr><td>Feasibility</td><td>9</td><td>11.5</td><td></td><td></td><td></td></tr><tr><td>Technology</td><td>5</td><td>6.4</td><td></td><td></td><td></td></tr><tr><td>Software platforms</td><td>2</td><td>2.6</td><td></td><td></td><td></td></tr><tr><td>DEVELOPMENT</td><td>Ⅱ</td><td>%</td><td>BMASSUMPTION</td><td>Ⅱ</td><td>%</td></tr><tr><td>Both (Incr.&amp; Disr.)</td><td>36</td><td>46.8</td><td>Closed</td><td>39</td><td>50.0</td></tr><tr><td>Incremental</td><td>27</td><td>35.1</td><td>Open</td><td>23</td><td>29.5</td></tr><tr><td>Disruptive</td><td>14</td><td>18.2</td><td>Both (cl.&amp;op.)</td><td>12</td><td>15.4</td></tr><tr><td></td><td></td><td></td><td>-(not identified)</td><td>4</td><td>5.1</td></tr><tr><td>METHODOFSTUDY</td><td>Ⅱ</td><td>%</td><td>TYPEOFSTUDY</td><td>Ⅱ</td><td>%</td></tr><tr><td>Exploratory</td><td>52</td><td>66.7</td><td>Qualitative</td><td>54</td><td>69.2</td></tr><tr><td>Empirical</td><td>13</td><td>16.7</td><td>Quantitative</td><td>19</td><td>24.4</td></tr><tr><td>Simulation</td><td>7</td><td>9.0</td><td>Mixed</td><td>5</td><td>6.4</td></tr><tr><td>Review</td><td>6</td><td>7.7</td><td></td><td></td><td></td></tr></table></body></html>

<html><body><table><tr><td>Feasibilty UserentrepreneurEmpirical Sustainability Industrial system ge Software platformsCompany Go,J.,&amp;Hart,A.J.(2017).FastDestop-ScaleExtrusionAdditiveaufacturing.Aditive Maufacturing,18,276284. Technology SoftwareplatfgrnsCompany Business models Useer Besmcek Comany Business models Global Sustainability Global Dsesse, Sustainability Global valbe htans Global Value chains Global P Value chains Global Business models Company de Jong,J. P.J.,&amp; de Bruijn,E. (2013).Inovation LessonsFrom3-DPrinting. MISloan ManagementReview,54(2),43–52. Business models Global Company</td></tr></table></body></html>